<?php

namespace App\Services;

use Codedge\Fpdf\Fpdf\Fpdf;
use Illuminate\Support\Carbon;

class PdfReportService extends Fpdf
{
    public function generate(array $data, string $uan)
    {
        $employmentHistory = $data['response']['employment_data'] ?? [];
        $firstRecord = $employmentHistory[0] ?? [];

        $this->AddPage('P', 'A4');
        $this->SetAutoPageBreak(true, 15);
        $this->SetMargins(20, 15, 20);
        $this->SetFont('Helvetica', '', 10);

        // --- Header ---
        $this->Cell(0, 5, 'Generated on ' . Carbon::now()->format('d-m-Y H:i:s'));
        $this->Ln(10);

        $this->SetFont('Helvetica', 'B', 16);
        $this->Cell(0, 8, 'EPFO - Employment History Fetch Report');
        $this->Ln(6);

        $this->SetFont('Helvetica', '', 10);
        $this->Cell(0, 5, '(Results as per UAN Authentication)');
        $this->Ln(15);
        
        // --- Personal Information ---
        $this->SetFont('Helvetica', '', 11);
        $this->Cell(40, 7, 'UAN');
        $this->Cell(0, 7, $uan);
        $this->Ln();
        $this->Cell(40, 7, 'NAME');
        $this->Cell(0, 7, strtoupper($firstRecord['name'] ?? 'N/A'));
        $this->Ln();
        $this->Cell(40, 7, "FATHER'S NAME");
        $this->Cell(0, 7, strtoupper($firstRecord['guardian_name'] ?? 'N/A'));
        $this->Ln(15);
        
        // --- Work History Section ---
        $this->SetFont('Helvetica', 'B', 14);
        $this->Cell(0, 10, 'Work History');
        $this->Ln(12);

        // --- Table ---
        if (empty($employmentHistory)) {
            $this->SetFont('Helvetica', '', 11);
            $this->Cell(0, 10, 'No employment history found.', 0, 1, 'C');
        } else {
            $this->drawTableHeader();
            $this->drawTableBody($employmentHistory);
        }

        // --- Footer URL ---
        $this->SetY(-30); // Position from bottom
        $this->SetFont('Helvetica', '', 10);
        $this->Cell(0, 10, 'https://unifiedportal-epfo.epfindia.gov.in/fointerface', 0, 0, 'C');
    }

    private function drawTableHeader()
    {
        $colWidths = [
            "sl" => 10, "id" => 40, "name" => 55, "join" => 22, "exit" => 22, "pf" => 21
        ];

        $this->SetFont('Helvetica', 'B', 9);
        $this->SetFillColor(240, 240, 240);

        $headerLineHeight = 5;
        $totalHeaderHeight = $headerLineHeight * 2;

        $x = $this->GetX();
        $y = $this->GetY();

        $this->MultiCell($colWidths["sl"], $headerLineHeight, "SL\nNo", 1, 'C', true);
        $this->SetXY($x + $colWidths["sl"], $y);
        $this->MultiCell($colWidths["id"], $totalHeaderHeight, "Member ID", 1, 'C', true);
        $this->SetXY($x + $colWidths["sl"] + $colWidths["id"], $y);
        $this->MultiCell($colWidths["name"], $totalHeaderHeight, "Establishment Name", 1, 'C', true);
        $this->SetXY($x + $colWidths["sl"] + $colWidths["id"] + $colWidths["name"], $y);
        $this->MultiCell($colWidths["join"], $headerLineHeight, "Date of\nJoining", 1, 'C', true);
        $this->SetXY($x + $colWidths["sl"] + $colWidths["id"] + $colWidths["name"] + $colWidths["join"], $y);
        $this->MultiCell($colWidths["exit"], $headerLineHeight, "Date of\nExit", 1, 'C', true);
        $this->SetXY($x + $colWidths["sl"] + $colWidths["id"] + $colWidths["name"] + $colWidths["join"] + $colWidths["exit"], $y);
        $this->MultiCell($colWidths["pf"], $headerLineHeight, "Last PF\nSubmitted", 1, 'C', true);
        
        $this->Ln($totalHeaderHeight - 10); // Adjust space after header
    }

    private function drawTableBody(array $employmentHistory)
    {
        $colWidths = [
            "sl" => 10, "id" => 40, "name" => 55, "join" => 22, "exit" => 22, "pf" => 21
        ];

        $this->SetFont('Helvetica', '', 8);
        $i = 1;
        foreach ($employmentHistory as $record) {
            $this->Cell($colWidths["sl"], 8, $i++, 1, 0, 'C');
            $this->Cell($colWidths["id"], 8, $record['member_id'] ?? 'N/A', 1, 0, 'C');
            $this->Cell($colWidths["name"], 8, strtoupper($record['establishment_name'] ?? 'N/A'), 1, 0, 'L');
            $this->Cell($colWidths["join"], 8, str_replace('/', '-', $record['date_of_joining'] ?? 'N/A'), 1, 0, 'C');
            $this->Cell($colWidths["exit"], 8, str_replace('/', '-', $record['date_of_exit'] ?? 'N/A'), 1, 0, 'C');
            $this->Cell($colWidths["pf"], 8, $record['last_pf_submitted'] ?? 'N/A', 1, 1, 'C');
        }
    }
}