<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - UAN Report Generator</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <style>
        .loader { border-top-color: #3498db; animation: spinner 1.5s linear infinite; }
        @keyframes spinner { 0% { transform: rotate(0deg); } 100% { transform: rotate(360deg); } }
    </style>
</head>
<body class="bg-gray-100">

    <nav class="bg-white shadow-sm">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between h-16">
                <div class="flex-shrink-0 flex items-center">
                    <svg class="w-8 h-8 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
                    <h1 class="ml-2 text-xl font-bold text-gray-800">OneTouch Verify</h1>
                </div>
                <div class="flex items-center">
                    <form action="<?php echo e(route('logout')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="text-gray-500 hover:text-gray-700 font-medium">Logout</button>
                    </form>
                </div>
            </div>
        </div>
    </nav>
    
    <main class="py-10">
        <div class="max-w-2xl mx-auto" x-data="formHandler()">
            <div class="bg-white rounded-lg shadow-lg overflow-hidden">
                <div class="px-6 py-8 sm:px-10">
                    <h2 class="text-2xl font-bold text-center text-gray-800 mb-2">EPFO Report Generator</h2>
                    <p class="text-center text-gray-500 mb-8">Generate employment history reports instantly.</p>

                    <!-- Error Display Area -->
                    <div x-show="errorMessage" class="bg-red-100 border-l-4 border-red-500 text-red-700 p-4 mb-6" role="alert">
                        <p class="font-bold">Error</p>
                        <p x-text="errorMessage"></p>
                    </div>

                    <form id="reportForm" @submit.prevent="submitForm">
                        <?php echo csrf_field(); ?>
                        <div class="mb-6">
                            <div class="flex border-b border-gray-200">
                                <button type="button" @click="requestType = 'single'" :class="{'border-blue-500 text-blue-600': requestType === 'single', 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300': requestType !== 'single'}" class="w-1/2 py-4 px-1 text-center border-b-2 font-medium text-sm focus:outline-none transition-colors duration-300">Single UAN</button>
                                <button type="button" @click="requestType = 'multiple'" :class="{'border-blue-500 text-blue-600': requestType === 'multiple', 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300': requestType !== 'multiple'}" class="w-1/2 py-4 px-1 text-center border-b-2 font-medium text-sm focus:outline-none transition-colors duration-300">Multiple UAN</button>
                            </div>
                        </div>

                        <div x-show="requestType === 'single'" x-transition><label for="uan_single" class="block text-gray-700 text-sm font-bold mb-2">UAN Number</label><input type="text" name="uan_single" class="shadow-sm appearance-none border rounded w-full py-3 px-4 text-gray-700 leading-tight focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent" placeholder="Enter 12-digit UAN"></div>
                        <div x-show="requestType === 'multiple'" x-transition style="display: none;"><label class="block text-gray-700 text-sm font-bold mb-2">Upload (.txt file)</label><div class="mt-1 flex justify-center px-6 pt-5 pb-6 border-2 border-gray-300 border-dashed rounded-md"><div class="space-y-1 text-center"><svg class="mx-auto h-12 w-12 text-gray-400" stroke="currentColor" fill="none" viewBox="0 0 48 48" aria-hidden="true"><path d="M28 8H12a4 4 0 00-4 4v20m32-12v8m0 0v8a4 4 0 01-4 4H12a4 4 0 01-4-4v-4m32-4l-3.172-3.172a4 4 0 00-5.656 0L28 28M8 32l9.172-9.172a4 4 0 015.656 0L28 28m0 0l4 4m4-24h8m-4-4v8" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" /></svg><div class="flex text-sm text-gray-600"><label for="uan_file" class="relative cursor-pointer bg-white rounded-md font-medium text-blue-600 hover:text-blue-500 focus-within:outline-none focus-within:ring-2 focus-within:ring-offset-2 focus-within:ring-blue-500"><span>Upload a file</span><input id="uan_file" name="uan_file" type="file" class="sr-only" @change="fileName = $event.target.files[0].name"></label><p class="pl-1">or drag and drop</p></div><p class="text-xs text-gray-500" x-show="!fileName">TXT file with one UAN per line</p><p class="text-xs font-medium text-green-600" x-show="fileName" x-text="fileName"></p></div></div></div>
                        <div class="mt-8"><button type="submit" class="w-full bg-blue-600 hover:bg-blue-700 text-white font-bold py-3 px-4 rounded-lg focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition duration-150 ease-in-out">Submit & Generate Report</button></div>
                    </form>
                </div>
            </div>
            <div x-show="isLoading" class="fixed inset-0 bg-gray-800 bg-opacity-75 flex items-center justify-center z-50" style="display: none;"><div class="flex items-center justify-center flex-col"><div class="loader ease-linear rounded-full border-8 border-t-8 border-gray-200 h-24 w-24 mb-4"></div><h2 class="text-center text-white text-xl font-semibold">Generating Reports...</h2><p class="w-2/3 md:w-1/3 text-center text-white mt-2">Please wait, your download will begin shortly.</p></div></div>
        </div>
    </main>

    <script>
        function formHandler() {
            return {
                requestType: 'single',
                isLoading: false,
                errorMessage: '',
                fileName: '',
                
                async submitForm() {
                    this.isLoading = true;
                    this.errorMessage = '';
                    
                    const form = document.getElementById('reportForm');
                    const formData = new FormData(form);
                    formData.append('request_type', this.requestType);

                    try {
                        const response = await fetch("<?php echo e(route('report.generate')); ?>", {
                            method: 'POST',
                            body: formData,
                            headers: {
                                'X-CSRF-TOKEN': document.querySelector('input[name="_token"]').value,
                                'Accept': 'application/json',
                            },
                        });

                        const result = await response.json();

                        if (!response.ok) {
                            // Handle validation or server errors
                            this.errorMessage = result.message || 'An unknown error occurred.';
                        } else if (result.success) {
                            // Create a temporary link to trigger the download
                            const link = document.createElement('a');
                            link.href = result.download_url;
                            link.setAttribute('download', result.file_name);
                            document.body.appendChild(link);
                            link.click();
                            document.body.removeChild(link); // Clean up the link
                        } else {
                            this.errorMessage = result.message || 'Failed to generate the report.';
                        }

                    } catch (error) {
                        console.error('Submission error:', error);
                        this.errorMessage = 'A network error occurred. Please check your connection and try again.';
                    } finally {
                        this.isLoading = false;
                    }
                }
            }
        }
    </script>
</body>
</html><?php /**PATH C:\xampp\htdocs\uan-report-generator\resources\views/dashboard.blade.php ENDPATH**/ ?>